#pragma GCC optimize("Ofast,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,popcnt,lzcnt")

#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>
#include <random>

using namespace std;

using ll = long long;

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n, m;
    cin >> n >> m;
    vector<vector<int>> adj(n + 1);
    while (m--)
    {
        int a, b;
        cin >> a >> b;
        adj[a].push_back(b);
    }
    random_device rd;
    mt19937 gen(rd());
    for (int i = 1; i <= n; ++i)
    {
        shuffle(adj[i].begin(), adj[i].end(), gen);
    }
    vector<int> res;
    vector<bool> used(n + 1);
    int cnt = 0;
    auto dfs = [&res, &used, &adj, &cnt, &n](auto self, int v) -> void
    {
        used[v] = true;
        ++cnt;
        for (int u : adj[v])
        {
            if (u == 1 && cnt == n)
            {
                res.push_back(1);
                res.push_back(v);
                return;
            }
            if (!used[u])
            {
                self(self, u);
                if (!res.empty())
                {
                    res.push_back(v);
                    return;
                }
            }
        }
        --cnt;
        used[v] = false;
    };
    dfs(dfs, 1);
    if (res.empty()) cout << "NO\n";
    else
    {
        cout << "YES\n";
        reverse(res.begin(), res.end());
        for (int i : res) cout << i << ' ';
    }
    return 0;
}
